<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Caja extends Model
{
    protected $table = 'caja';
    protected $primaryKey = 'id_caja';

    protected $fillable = [
        'apertura', 'saldo', 'fecha_apertura', 'fecha_cierre',
        'nombre', 'saldo_final', 'observacion'
    ];

    public function transacciones()
    {
        return $this->hasMany(TransaccionCaja::class, 'caja_id');
    }

    public function historial()
    {
        return $this->hasMany(CajaHistorial::class, 'caja_id');
    }
}
