<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class NotaSubcomponente extends Model
{
    protected $table = 'notas_subcomponentes';

    protected $fillable = [
        'estudiante_id',
        'subcomponente_id',
        'nota',
    ];

    public function estudiante()
    {
        return $this->belongsTo(Postulante::class, 'estudiante_id', 'id_postulante');
    }

    public function subcomponente()
    {
        return $this->belongsTo(SubcomponenteLogro::class, 'subcomponente_id');
    }
}
