@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Sesiones del Curso {{ $curso->nombre }} @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <div class="mb-3 text-end">
                    <a href="{{ route('docente.cursos.informacion', $curso->id) }}" class="btn btn-danger btn-sm me-2">
                        <i class="fas fa-arrow-left"></i> Volver a Información del Curso
                    </a>
                    
                    <button type="button" class="btn btn-primary btn-sm px-3" 
                        data-bs-toggle="modal" 
                        data-bs-target="#modalNuevaSesion">
                        <i class="fas fa-plus"></i> Agregar Nueva Sesión
                    </button>
                </div>


                <div class="list-group">
                    @forelse ($sesiones as $sesion)
                        <div 
                            class="list-group-item list-group-item-action d-flex justify-content-between align-items-center rounded-3 mb-3 shadow-sm"
                            style="cursor: default;">
                            
                            <div>
                                <h5 class="mb-1 fw-semibold">{{ $sesion->nombre }}</h5>
                                <small class="text-muted">
                                    Inicio: {{ \Carbon\Carbon::parse($sesion->fecha)->format('d/m/Y') }} | 
                                    Fin: {{ \Carbon\Carbon::parse($sesion->fecha_fin)->format('d/m/Y') }}
                                </small>
                            </div>
                            
                            <div class="d-flex align-items-center gap-3">

                                <!-- Toggle switch -->
                                <div class="form-check form-switch m-0">
                                    <input 
                                        class="form-check-input toggleSesionEstado"
                                        type="checkbox"
                                        role="switch"
                                        data-id="{{ $sesion->id_sesion }}"
                                        {{ $sesion->activo ? 'checked' : '' }}>
                                    <label class="form-check-label small">
                                        {{ $sesion->activo ? 'Activo' : 'Inactivo' }}
                                    </label>
                                </div>

                                <button 
                                    class="btn btn-outline-primary btn-sm btnEditarSesion"
                                    data-id_sesion="{{ $sesion->id_sesion }}"
                                    data-nombre="{{ $sesion->nombre }}"
                                    data-fecha="{{ $sesion->fecha }}"
                                    data-fecha_fin="{{ $sesion->fecha_fin }}"
                                    data-bs-toggle="modal"
                                    data-bs-target="#modalEditarSesion">
                                    Editar
                                </button>

                                <button 
                                    class="btn btn-outline-danger btn-sm btnEliminarSesion"
                                    data-id="{{ $sesion->id_sesion }}">
                                    Eliminar
                                </button>

                                <a 
                                    href="{{ route('docente.archivos.index', $curso->id) }}" 
                                    class="btn btn-outline-info btn-sm">
                                    <i class="fas fa-folder-open"></i> Material
                                </a>

                            </div>
                        </div>
                    @empty
                        <div class="alert alert-warning text-center">
                            <i class="fas fa-exclamation-circle me-2"></i>No hay sesiones registradas para este curso.
                        </div>
                    @endforelse
                </div>



            </div>
        </div>
    </div>
</div>


<!-- Modal de agregar -->

<!-- Modal Nueva Sesión -->
<!-- Modal Nueva Sesión -->
<div class="modal fade" id="modalNuevaSesion" tabindex="-1" aria-labelledby="modalNuevaSesionLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalNuevaSesionLabel">Registrar Nueva Sesión</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <!-- Formulario Nueva Sesión -->
                <form id="formNuevaSesion" enctype="multipart/form-data">
                    @csrf

                    <div class="mb-3">
                        <label for="nombre" class="form-label">Nombre de la Sesión</label>
                        <input type="text" class="form-control" id="nombre" name="nombre" required>
                    </div>

                    <div class="mb-3">
                        <label for="fecha" class="form-label">Fecha de Inicio</label>
                        <input type="date" class="form-control" id="fecha" name="fecha" required>
                    </div>

                    <div class="mb-3">
                        <label for="fecha_fin" class="form-label">Fecha de Fin</label>
                        <input type="date" class="form-control" id="fecha_fin" name="fecha_fin" required>
                    </div>

                    <div class="mb-3">
                        <label for="archivo" class="form-label">Archivo Adjunto</label>
                        <input type="file" class="form-control" id="archivo" name="archivo">
                    </div>

                    <div class="mb-3">
                        <label for="estado" class="form-label">Estado</label>
                        <select class="form-select" id="estado" name="estado" required>
                            <option value="1">Activo</option>
                            <option value="0">Inactivo</option>
                        </select>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                        <button type="submit" class="btn btn-de-primary">Registrar Sesión</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


<!-- Modal de Edición -->

<!-- Modal Editar Sesión -->
<div class="modal fade" id="modalEditarSesion" tabindex="-1" aria-labelledby="modalEditarSesionLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form id="formEditarSesion" enctype="multipart/form-data">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalEditarSesionLabel">Editar Sesión</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="editar_sesion_id" name="sesion_id">
                    <div class="mb-3">
                        <label for="editar_nombre" class="form-label">Nombre</label>
                        <input type="text" class="form-control" id="editar_nombre" name="nombre" required>
                    </div>
                    <div class="mb-3">
                        <label for="editar_fecha" class="form-label">Fecha Inicio</label>
                        <input type="date" class="form-control" id="editar_fecha" name="fecha" required>
                    </div>
                    <div class="mb-3">
                        <label for="editar_fecha_fin" class="form-label">Fecha Fin</label>
                        <input type="date" class="form-control" id="editar_fecha_fin" name="fecha_fin" required>
                    </div>
                    <div class="mb-3">
                        <label for="editar_archivo" class="form-label">Archivo (opcional)</label>
                        <input type="file" class="form-control" id="editar_archivo" name="archivo">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Guardar Cambios</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                </div>
            </div>
        </form>
    </div>
</div>




<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>


<script>
    // Enviar el formulario por AJAX
    document.getElementById('formNuevaSesion').addEventListener('submit', function(e) {
        e.preventDefault();  // Prevenir el comportamiento predeterminado del formulario

        const formData = new FormData(this);  // Crear el objeto FormData para enviar los datos

        // Obtener el ID del curso
        const cursoId = "{{ $curso->id }}";

        // Realizar la solicitud AJAX
        axios.post(`/docentes/cursos/${cursoId}/sesiones`, formData)
            .then(function(response) {
                // Mostrar mensaje de éxito
                Swal.fire({
                    icon: 'success',
                    title: '¡Éxito!',
                    text: 'La sesión ha sido registrada correctamente.',
                    confirmButtonText: 'Cerrar'
                }).then(function(result) {
                    if (result.isConfirmed) {
                        // Recargar la página solo después de hacer clic en "Aceptar"
                        location.reload(); // o actualizar la tabla de sesiones
                    }
                });

                // Cerrar el modal (descomentado si es necesario)
                //$('#modalNuevaSesion').modal('hide');
            })
            .catch(function(error) {
                // Mostrar mensaje de error
                Swal.fire({
                    icon: 'error',
                    title: '¡Error!',
                    text: 'Hubo un problema al registrar la sesión. Por favor, inténtelo de nuevo.',
                    confirmButtonText: 'Cerrar'
                });
            });
    });
</script>

<script>
    document.querySelectorAll('.btnEditarSesion').forEach(button => {
        button.addEventListener('click', function () {
            const sesionId = this.getAttribute('data-id_sesion'); // ✅ ahora coinciden
            const nombre = this.getAttribute('data-nombre');
            const fecha = this.getAttribute('data-fecha');
            const fechaFin = this.getAttribute('data-fecha_fin');

            document.getElementById('editar_sesion_id').value = sesionId;
            document.getElementById('editar_nombre').value = nombre;
            document.getElementById('editar_fecha').value = fecha;
            document.getElementById('editar_fecha_fin').value = fechaFin;

            console.log('ID de la sesión que se va a editar:', sesionId);
        });
    });
</script>


<script>
    document.getElementById('formEditarSesion').addEventListener('submit', function(e) {
        e.preventDefault();

        const sesionId = document.getElementById('editar_sesion_id').value;
        console.log('ID de la sesión que se va a actualizar:', sesionId);

        const form = this;
        const formData = new FormData(form);
        formData.append('_method', 'PUT'); // Laravel entenderá que es una actualización

        axios.post(`/docentes/sesiones/${sesionId}`, formData) // Usamos POST
            .then(response => {
                Swal.fire({
                    icon: 'success',
                    title: 'Sesión actualizada',
                    text: 'La sesión fue modificada correctamente.',
                    confirmButtonText: 'Aceptar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        location.reload();
                    }
                });
            })
            .catch(error => {
                console.error(error);
                let mensaje = 'Hubo un problema al guardar los cambios.';

                // Mostrar errores de validación si existen
                if (error.response && error.response.data && error.response.data.errors) {
                    const errores = error.response.data.errors;
                    mensaje = Object.values(errores).map(e => e.join(', ')).join('\n');
                }

                Swal.fire({
                    icon: 'error',
                    title: 'Error al actualizar',
                    text: mensaje,
                });
            });
    });
</script>

<script>
    document.querySelectorAll('.btnEliminarSesion').forEach(button => {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            const sesionId = this.getAttribute('data-id');

            Swal.fire({
                title: '¿Estás seguro?',
                text: "Esta acción no se puede deshacer.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    axios.post(`/docentes/sesiones/${sesionId}`, {
                        _method: 'DELETE'
                    })
                    .then(response => {
                        Swal.fire({
                            icon: 'success',
                            title: 'Sesión eliminada',
                            text: 'La sesión fue eliminada correctamente.',
                            confirmButtonText: 'Aceptar'
                        }).then(() => {
                            location.reload();
                        });
                    })
                    .catch(error => {
                        console.error(error);
                        Swal.fire({
                            icon: 'error',
                            title: 'Error al eliminar',
                            text: 'Ocurrió un error al intentar eliminar la sesión.',
                        });
                    });
                }
            });
        });
    });
</script>


<script>
    document.querySelectorAll('.toggleSesionEstado').forEach(toggle => {
        toggle.addEventListener('change', function () {
            const idSesion = this.dataset.id;
            const estado = this.checked ? 1 : 0;

            axios.post(`/docentes/sesiones/${idSesion}/cambiar-estado`, {
                activo: estado,
                _token: '{{ csrf_token() }}'
            })
            .then(res => {
                Swal.fire('¡Actualizado!', res.data.message, 'success');
                this.nextElementSibling.textContent = estado ? 'Activo' : 'Inactivo';
            })
            .catch(err => {
                Swal.fire('Error', 'No se pudo actualizar el estado.', 'error');
                this.checked = !estado; // Revertir cambio si hay error
            });
        });
    });
</script>


@endsection
