@forelse($ofertas as $oferta)
    <!-- Tarjeta de Oferta -->
    <div class="col-md-6 col-lg-4 mb-4">
        <div class="card shadow-sm h-100">
            <div class="card-body d-flex flex-column">
                <h5 class="card-title text-primary">{{ $oferta->titulo }}</h5>

                <p class="mb-1 text-truncate" title="{{ $oferta->empresa->nombre ?? 'Empresa desconocida' }}">
                    <i class="fas fa-building me-1"></i> {{ $oferta->empresa->nombre_empresa ?? 'Empresa desconocida' }}
                </p>
                <p class="mb-1">
                    <i class="fas fa-calendar-day me-1"></i> Publicado: {{ \Carbon\Carbon::parse($oferta->fecha_publicacion)->format('d/m/Y') }}
                </p>
                <p class="mb-1 text-truncate" title="{{ $oferta->lugar }}">
                    <i class="fas fa-map-marker-alt me-1"></i> {{ $oferta->lugar }}
                </p>
                <p class="mb-2">
                    <i class="fas fa-file-contract me-1"></i> {{ $oferta->tipoContrato->nombre_tipo_contrato ?? 'Tipo no definido' }}
                </p>

                @if ($oferta->archivo_pdf && file_exists(public_path($oferta->archivo_pdf)))
                    <a href="{{ asset($oferta->archivo_pdf) }}" class="btn btn-outline-info btn-sm mt-auto mb-2" target="_blank">
                        Ver Documento <i class="fas fa-file-pdf ms-1"></i>
                    </a>
                @else
                    <span class="text-muted mt-auto mb-2">Sin documento disponible</span>
                @endif

                <button class="btn btn-primary btn-sm" onclick="mostrarModal({{ $oferta->id_oferta }})">
                    Ver Más <i class="fas fa-eye ms-1"></i>
                </button>


            </div>
        </div>
    </div>

   
@empty
    <div class="col-12">
        <div class="alert alert-warning">No hay ofertas disponibles actualmente.</div>
    </div>
@endforelse
