<div class="mb-3">
    <h5 class="fw-bold text-primary">
        <i class="bi bi-journal-check me-2"></i> {{ $curso->nombre }}
    </h5>
    <p class="mb-1"><strong>Nota Final:</strong>
        @if($notaFinal && is_numeric($notaFinal->promedio))
            <span class="{{ $notaFinal->promedio >= 11 ? 'text-success' : 'text-danger' }}">
                {{ number_format($notaFinal->promedio, 2) }}
            </span>
        @else
            <span class="text-muted">-</span>
        @endif
    </p>
</div>

@if($logros->isEmpty())
    <div class="alert alert-warning">
        No hay logros registrados para este curso.
    </div>
@else
    @foreach($logros as $logro)
        @php
            $notaLogro = $logro->notasLogro()
                ->where('estudiante_id', $estudianteId)
                ->where('curso_id', $curso->id)
                ->first();
        @endphp

        <div class="card mb-3 border shadow-sm rounded-4">
            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                <span class="fw-semibold">
                    <i class="bi bi-star-fill text-warning me-2"></i>{{ $logro->nombre }}
                </span>
                <span class="badge bg-secondary">
                    Nota Logro:
                    @if($notaLogro)
                        {{ number_format($notaLogro->nota, 2) }}
                    @else
                        -
                    @endif
                </span>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-sm mb-0 table-hover table-striped">
                        <thead class="table-light">
                            <tr>
                                <th>Subcomponente</th>
                                <th>Peso (%)</th>
                                <th>Nota</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($logro->subcomponentes as $sub)
                                @php
                                    $notaSub = $sub->notas()
                                        ->where('estudiante_id', $estudianteId)
                                        ->first();
                                @endphp
                                <tr>
                                    <td>{{ $sub->nombre }}</td>
                                    <td>{{ $sub->peso }}%</td>
                                    <td>
                                        @if($notaSub)
                                            <span class="{{ $notaSub->nota >= 11 ? 'text-success' : 'text-danger' }}">
                                                {{ number_format($notaSub->nota, 2) }}
                                            </span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="3" class="text-center text-muted">No hay subcomponentes registrados.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    @endforeach
@endif
