@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Estudiantes @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                
                <div class="d-flex mb-3">
                    <div>
                        <a href="{{ route('estudiantes.create') }}" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3">
                            <i class="fas fa-plus"></i> Nuevo Estudiante
                        </a>
                         <button type="button" class="btn btn-success btn-sm px-4 mt-0 mb-3 ms-2"
                                data-bs-toggle="modal"
                                data-bs-target="#modalImportarEstudiantes">
                            <i class="fas fa-file-excel"></i> Importación Masiva
                        </button>

                        
                    </div>
                </div>

                <div class="table-responsive">
                    <table id="tablaPostulantes" class="table table-striped mb-0 table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>#</th>
                                <th>Nombre Completo</th>
                                <th>DNI</th>
                                <th>Correo</th>
                                <th>Teléfono</th>
                                <th>Fecha de Nacimiento</th>
                                <th>Grado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($postulantes as $index => $postulante)
                            <tr>
                                <td>{{ $postulante->id_postulante }}</td>
                                <td>{{ $postulante->nombres }} {{ $postulante->apellidos }}</td>
                                <td>{{ $postulante->dni }}</td>
                                <td>{{ $postulante->email }}</td>
                                <td>{{ $postulante->telefono }}</td>
                                <td>{{ $postulante->fecha_nacimiento }}</td>
                                <td>{{ $postulante->grado }}</td>
                                <td>
                                    <!-- Botón Ver -->
                                    <a href="{{ route('estudiantes.show', $postulante->id_postulante) }}" class="text-info me-2" title="Ver detalles">
                                        <i class="las la-eye font-18"></i>
                                    </a>
                                    <!-- Icono de editar -->
                                    <a href="#" class="btn-editar-postulante" data-bs-toggle="modal" data-bs-target="#editModal"
                                        data-id="{{ $postulante->id_postulante }}"
                                        data-nombres="{{ $postulante->nombres }}"
                                        data-apellidos="{{ $postulante->apellidos }}"
                                        data-email="{{ $postulante->email }}"
                                        data-telefono="{{ $postulante->telefono }}"
                                        data-direccion="{{ $postulante->direccion }}"
                                        data-fecha_nacimiento="{{ $postulante->fecha_nacimiento }}"
                                        data-grado="{{ $postulante->grado }}">
                                        <i class="las la-pen text-secondary font-18"></i>
                                    </a>

                                    <!-- Icono de eliminar -->
                                    <a href="#" class="text-danger btn-eliminar-postulante" data-id="{{ $postulante->id_postulante }}">
                                        <i class="las la-trash-alt text-secondary font-18"></i>
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>   

                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal de agregar -->
<!-- Modal para crear nuevo requisito -->

<div class="modal fade" id="modalImportarEstudiantes" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <form id="formImportarEstudiantes" enctype="multipart/form-data">
            @csrf

            <div class="modal-content">

                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title">
                        <i class="fas fa-users"></i> Importación Masiva de Estudiantes
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">

                    <div class="row">

                        <!-- SUBIR ARCHIVO -->
                        <div class="col-md-6 mb-3">
                            <label class="fw-bold">Subir Archivo Excel</label>
                            <input type="file" name="archivo" class="form-control" required>
                            <small class="text-muted">Formatos permitidos: .xlsx, .xls</small>
                        </div>

                        <!-- INSTRUCCIONES -->
                        <div class="col-md-6 mb-3">
                            <label class="fw-bold">Instrucciones</label>
                            <ul class="small">
                                <li>Descarga la plantilla modelo.</li>
                                <li>Llena los campos: <strong>DNI, Nombres, Apellidos, Email, Teléfono</strong>.</li>
                                <li>Todos los estudiantes se registrarán con el grado <strong>Estudiante</strong>.</li>
                                <li>El usuario y contraseña será su DNI.</li>
                            </ul>

                            <a href="{{ asset('plantillas/plantilla_estudiantes.xlsx') }}"
                               class="btn btn-outline-primary btn-sm">
                                <i class="fas fa-download"></i> Descargar Plantilla
                            </a>
                        </div>

                    </div>

                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-upload"></i> Importar Excel
                    </button>
                </div>

            </div>

        </form>
    </div>
</div>








<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaPostulantes").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaPostulantes_wrapper .col-md-6:eq(0)');
    });
</script>




<script>
$(document).ready(function () {

    $('#formImportarEstudiantes').submit(function (e) {
        e.preventDefault();

        let formData = new FormData(this);

        Swal.fire({
            title: 'Importando...',
            text: 'Procesando archivo, por favor espere.',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
        });

        $.ajax({
            url: "{{ route('estudiantes.importar') }}",
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,

            success: function (response) {
                Swal.close();

                Swal.fire({
                    icon: 'success',
                    title: 'Estudiantes importados',
                    text: response.message,
                    timer: 2000,
                    showConfirmButton: false
                });

                $('#modalImportarEstudiantes').modal('hide');

                setTimeout(() => location.reload(), 1200);
            },

            error: function (xhr) {
                Swal.close();

                if (xhr.status === 422) {
                    let msg = "";

                    if (xhr.responseJSON.errors) {
                        xhr.responseJSON.errors.forEach(e => msg += e + "<br>");
                    }

                    Swal.fire({
                        icon: 'error',
                        title: 'Errores en el archivo',
                        html: msg
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error inesperado',
                        text: xhr.responseJSON?.message ?? 'No se pudo procesar el archivo.'
                    });
                }
            }
        });

    });

});
</script>





@endsection
