@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Caja @endslot
@slot('title') Reporte de Ingresos @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                

                
                <div class="card-body">
                    <form id="form-filtro" class="row gy-2 gx-3 align-items-center mb-4">
                        <div class="col-md-3">
                            <label>Desde:</label>
                            <input type="date" name="fecha_inicio" class="form-control">
                        </div>
                        <div class="col-md-3">
                            <label>Hasta:</label>
                            <input type="date" name="fecha_fin" class="form-control">
                        </div>
                        <div class="col-md-3">
                            <label>Caja:</label>
                            <select name="caja_id" class="form-select">
                                <option value="">Todas</option>
                                @foreach($cajas as $caja)
                                    <option value="{{ $caja->id_caja }}">{{ $caja->nombre }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="d-block">&nbsp;</label>
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-de-primary w-100">
                                    <i class="fas fa-search me-1"></i> Buscar
                                </button>
                                <a href="#" id="btnExportarPDF" class="btn btn-outline-danger" target="_blank" title="Exportar a PDF">
                                    <i class="bi bi-file-earmark-pdf"></i>
                                </a>
                            </div>
                        </div>

                    </form>

                    <form id="formExportarPDF" action="{{ route('reportes.egresos.pdf') }}" method="POST" target="_blank" style="display: none;">
                        @csrf
                        <input type="hidden" name="fecha_inicio">
                        <input type="hidden" name="fecha_fin">
                        <input type="hidden" name="caja_id">
                    </form>


                    <div id="resultadoIngresos">
                        {{-- Aquí se cargarán los resultados vía AJAX --}}
                    </div>
                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>






@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    const formFiltro = document.getElementById('form-filtro');
    const formExportar = document.getElementById('formExportarPDF');

    formFiltro.addEventListener('submit', function(e) {
        e.preventDefault();
        const formData = new FormData(formFiltro);

        fetch("{{ route('reportes.egresos.buscar') }}", {
            method: "POST",
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: formData
        })
        .then(res => res.json())
        .then(data => {
            document.getElementById('resultadoIngresos').innerHTML = data.html;

            // ✅ Destruir DataTable anterior si existe
            if ($.fn.DataTable.isDataTable('#tablaSemestres')) {
                $('#tablaSemestres').DataTable().destroy();
            }

            // ✅ Inicializar DataTable sobre el nuevo contenido
            $('#tablaSemestres').DataTable({
                responsive: true,
                lengthChange: true,
                autoWidth: false,
                buttons: [
                    {
                        extend: 'collection',
                        text: 'Opciones',
                        buttons: [
                            { extend: 'copy', text: 'Copiar' },
                            { extend: 'csv', text: 'CSV' },
                            { extend: 'excel', text: 'Excel', title: 'Reporte de Ingresos' },
                            { extend: 'pdf', text: 'PDF' },
                            { extend: 'print', text: 'Imprimir' }
                        ]
                    },
                    { extend: 'colvis', text: 'Visibilidad de Columna' }
                ],
                paging: true,
                searching: true,
                info: true,
                language: {
                    search: "Buscar:",
                    lengthMenu: "Mostrar _MENU_ registros por página",
                    info: "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                    paginate: {
                        first: "Primero",
                        previous: "Anterior",
                        next: "Siguiente",
                        last: "Último"
                    }
                }
            }).buttons().container().appendTo('#tablaSemestres_wrapper .col-md-6:eq(0)');

            // ✅ Copiar filtros al formulario de exportación
            formExportar.fecha_inicio.value = formData.get('fecha_inicio');
            formExportar.fecha_fin.value = formData.get('fecha_fin');
            formExportar.caja_id.value = formData.get('caja_id');
        })
        .catch(() => {
            Swal.fire('Error', 'Ocurrió un error al buscar ingresos.', 'error');
        });
    });

    // ✅ Envío del formulario oculto al hacer clic en el botón Exportar PDF
    document.getElementById('btnExportarPDF').addEventListener('click', function () {
        formExportar.submit();
    });
</script>







@endsection
