<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Logros de: <?php echo e($curso->nombre); ?> <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button type="button" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3" 
                    data-bs-toggle="modal" 
                    data-bs-target="#modalNuevoLogro">
                    <i class="fas fa-plus"></i> Agregar Nuevo Logro
                </button>
                <div class="table-responsive">
                    <table id="tablaLogros" class="table table-striped mb-0 table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Nombre</th>
                                <th>Descripción</th>
                                <th>Fecha Creación</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $logros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $logro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($logro->id); ?></td>
                                    <td><?php echo e($logro->nombre); ?></td>
                                    <td><?php echo e($logro->descripcion); ?></td>
                                    <td><?php echo e(\Carbon\Carbon::parse($logro->fecha_creacion)->format('Y-m-d H:i')); ?></td>

                                    <td>
                                        <!-- Icono editar -->
                                        <a href="#" class="text-warning btn-editar-logro" data-id="<?php echo e($logro->id); ?>">
                                            <i class="las la-pen text-secondary font-18"></i>
                                        </a>


                                        <!-- Icono eliminar -->
                                        <button type="button" 
                                                class="btn btn-link p-0 text-danger btn-eliminar-logro" 
                                                data-id="<?php echo e($logro->id); ?>">
                                            <i class="las la-trash-alt text-secondary font-18"></i>
                                        </button>


                                        <!-- Ver subcomponentes -->
                                        <a href="<?php echo e(route('docente.subcomponentes.index', ['logro' => $logro->id])); ?>"
                                            class="text-info ms-2" title="Ver Subcomponentes">
                                            <i class="las la-layer-group text-secondary font-18"></i>
                                        </a>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>



                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal de agregar -->
<!-- Modal: Agregar Nuevo Logro -->
<div class="modal fade" id="modalNuevoLogro" tabindex="-1" aria-labelledby="modalNuevoLogroLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header ">
                <h5 class="modal-title" id="modalNuevoLogroLabel"><i i class="fas fa-trophy me-1 text-primary"></i> Agregar Nuevo Logro</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <form id="formNuevoLogro">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <input type="hidden" name="curso_id" value="<?php echo e($curso->id); ?>">
                    
                    <div class="mb-3">
                        <label for="nombre" class="form-label">Nombre del Logro</label>
                        <input type="text" class="form-control" id="nombre" name="nombre" required>
                    </div>

                    <div class="mb-3">
                        <label for="descripcion" class="form-label">Descripción</label>
                        <textarea class="form-control" id="descripcion" name="descripcion" rows="3" required></textarea>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar Logro</button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- Modal: editar Logro -->
<div class="modal fade" id="modalEditarLogro" tabindex="-1" aria-labelledby="modalEditarLogroLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header ">
                <h5 class="modal-title" id="modalEditarLogroLabel"><i class="fas fa-edit me-1 bg-soft-primary"></i> Editar Logro</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <form id="formEditarLogro">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <input type="hidden" id="edit_logro_id">

                    <div class="mb-3">
                        <label for="edit_nombre" class="form-label">Nombre del Logro</label>
                        <input type="text" class="form-control" id="edit_nombre" name="nombre" required>
                    </div>

                    <div class="mb-3">
                        <label for="edit_descripcion" class="form-label">Descripción</label>
                        <textarea class="form-control" id="edit_descripcion" name="descripcion" rows="3" required></textarea>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Actualizar Logro</button>
                </div>
            </form>
        </div>
    </div>
</div>




<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<!-- DataTables  -->
<script>
    $(document).ready(function () {
        $("#tablaLogros").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaLogros_wrapper .col-md-6:eq(0)');
    });
</script>
<!-- Agregar -->
<script>
    $(document).ready(function() {
        $('#formNuevoLogro').on('submit', function(e) {
            e.preventDefault();

            let form = $(this);
            let action = "<?php echo e(route('docente.logros.store', ['curso' => $curso->id])); ?>";
            let formData = form.serialize();

            $.ajax({
                url: action,
                method: 'POST',
                data: formData,
                success: function(response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Logro registrado',
                        text: 'El logro fue agregado correctamente.',
                        timer: 2000,
                        showConfirmButton: false
                    });

                    // Cerrar el modal
                    $('#modalNuevoLogro').modal('hide');

                    // Limpiar el formulario
                    form[0].reset();

                    // Recargar la tabla (asume que tienes una función o endpoint para eso)
                    $('#tablaLogros').load(location.href + " #tablaLogros>*", "");
                },
                error: function(xhr) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'No se pudo registrar el logro. Intenta nuevamente.'
                    });
                }
            });
        });
    });
</script>

<!-- editar -->
<script>
    // Abrir modal y cargar datos
    $(document).on('click', '.btn-editar-logro', function (e) {
        e.preventDefault();
        const id = $(this).data('id');

        $.get(`/docentes/logros/${id}/edit`, function (data) {
            $('#edit_logro_id').val(data.id);
            $('#edit_nombre').val(data.nombre);
            $('#edit_descripcion').val(data.descripcion);
            $('#modalEditarLogro').modal('show');
        }).fail(() => {
            Swal.fire('Error', 'No se pudo cargar el logro.', 'error');
        });
    });

    // Enviar actualización por AJAX
    $('#formEditarLogro').submit(function (e) {
        e.preventDefault();

        const id = $('#edit_logro_id').val();
        const nombre = $('#edit_nombre').val();
        const descripcion = $('#edit_descripcion').val();

        $.ajax({
            url: `/docentes/logros/${id}`,
            type: 'PUT',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                nombre: nombre,
                descripcion: descripcion
            },
            success: function (response) {
                $('#modalEditarLogro').modal('hide');
                Swal.fire('Éxito', 'Logro actualizado correctamente.', 'success');

                // Refrescar la tabla sin recargar (puedes mejorar esto con DataTables)
                setTimeout(() => location.reload(), 1000);
            },
            error: function () {
                Swal.fire('Error', 'No se pudo actualizar el logro.', 'error');
            }
        });
    });
</script>
<!-- eliminar -->
<script>
    document.addEventListener('DOMContentLoaded', function () {
        $('.btn-eliminar-logro').on('click', function () {
            let logroId = $(this).data('id');

            Swal.fire({
                title: '¿Estás seguro?',
                text: "¡Esta acción no se puede deshacer!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: `/docentes/logros/${logroId}`,
                        type: 'POST',
                        data: {
                            _method: 'DELETE',
                            _token: '<?php echo e(csrf_token()); ?>'
                        },
                        success: function (response) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Eliminado',
                                text: response.message || 'Logro eliminado correctamente',
                                timer: 2000,
                                showConfirmButton: false
                            });

                            // Eliminar la fila de la tabla sin recargar
                            $(`button[data-id="${logroId}"]`).closest('tr').remove();
                        },
                        error: function (xhr) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: xhr.responseJSON?.message || 'No se pudo eliminar el logro.'
                            });
                        }
                    });
                }
            });
        });
    });
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\SISTEMAS\academico-master\resources\views/docentes/logros/index.blade.php ENDPATH**/ ?>