<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Gestión de Asistencia - <?php echo e($curso->nombre); ?> <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">

                <div class="mb-3 text-end">
                    <a href="<?php echo e(route('docente.cursos.informacion', $curso->id)); ?>" class="btn btn-danger btn-sm me-2">
                        <i class="fas fa-arrow-left"></i> Volver a Información del Curso
                    </a>

                    <a href="<?php echo e(route('docente.asistencia.reporte.pdf', $curso->id)); ?>" target="_blank" class="btn btn-primary btn-sm">
                        <i class="fas fa-file-pdf"></i> Reporte Asistencia
                    </a>
                </div>

                
                <div class="table-responsive">
                    
                    <?php if($sesiones->isEmpty()): ?>
                        <div class="alert alert-warning">
                            No hay sesiones activas para este curso.
                        </div>
                    <?php else: ?>
                        
                        <form id="formAsistencia" method="POST">
                            <?php echo csrf_field(); ?>
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Estudiante</th>
                                        <?php $__currentLoopData = $sesiones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sesion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <th><?php echo e($sesion->nombre); ?></th>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    
                                    <?php $__currentLoopData = $matriculados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $matriculaCurso): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($matriculaCurso->nombre); ?></td>

                                            
                                            <?php $__currentLoopData = $sesiones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sesion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    // Buscar la asistencia para esta sesión
                                                    $asistencia = $matriculaCurso->asistencias_por_sesion[$sesion->id_sesion] ?? null;
                                                    $estado = $asistencia ? $asistencia['estado'] : 'P';
                                                    $observacion = $asistencia ? $asistencia['observaciones'] : '';
                                                ?>

                                                <td>
                                                    
                                                    <select name="asistencias[<?php echo e($matriculaCurso->matricula_curso_id); ?>][<?php echo e($sesion->id_sesion); ?>]" class="form-control form-control-sm">
                                                        <option value="P" <?php echo e($estado == 'P' ? 'selected' : ''); ?>>P</option>
                                                        <option value="F" <?php echo e($estado == 'F' ? 'selected' : ''); ?>>F</option>
                                                        <option value="J" <?php echo e($estado == 'J' ? 'selected' : ''); ?>>J</option>
                                                    </select>

                                                    
                                                    <input 
                                                        type="text" 
                                                        class="form-control form-control-sm" 
                                                        name="observaciones[<?php echo e($matriculaCurso->matricula_curso_id); ?>][<?php echo e($sesion->id_sesion); ?>]" 
                                                        placeholder="Observaciones"
                                                        value="<?php echo e($observacion); ?>"
                                                    >
                                                </td>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>

                            
                            <div class="text-center mt-3">
                                <button type="submit" class="btn btn-success">Guardar Asistencia</button>
                            </div>
                        </form>


                    <?php endif; ?>



                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal de agregar -->
<!-- Modal: Nuevo Semestre -->





<!-- Modal de Edición -->






<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


    <script>
            $(document).ready(function () {
                $("#tablaSemestres").DataTable({
                    "responsive": true,
                    "lengthChange": true,
                    "autoWidth": false,
                    "buttons": [
                        {
                            extend: 'collection',
                            text: 'Opciones',
                            buttons: [
                                { extend: 'copy', text: 'Copiar' },
                                { extend: 'csv', text: 'CSV' },
                                { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                                { extend: 'pdf', text: 'PDF' },
                                { extend: 'print', text: 'Imprimir' }
                            ]
                        },
                        { extend: 'colvis', text: 'Visibilidad de Columna' }
                    ],
                    "paging": true,
                    "searching": true,
                    "info": true,
                    "language": {
                        "search": "Buscar:",
                        "lengthMenu": "Mostrar _MENU_ registros por página",
                        "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                        "paginate": {
                            "first": "Primero",
                            "previous": "Anterior",
                            "next": "Siguiente",
                            "last": "Último"
                        }
                    }
                }).buttons().container().appendTo('#tablaSemestres_wrapper .col-md-6:eq(0)');
            });
    </script>

<script>
document.getElementById('formAsistencia').addEventListener('submit', function(e) {
    e.preventDefault();

    let form = this;
    let asistencias = {};
    let observaciones = {};

    // Recorrer los selects de asistencias
    form.querySelectorAll('select[name^="asistencias"]').forEach(select => {
        const nameParts = select.name.match(/asistencias\[(\d+)\]\[(\d+)\]/);
        if (nameParts) {
            const matriculaCursoId = nameParts[1];
            const sesionId = nameParts[2];

            if (!asistencias[matriculaCursoId]) {
                asistencias[matriculaCursoId] = {};
            }

            asistencias[matriculaCursoId][sesionId] = select.value;
        }
    });

    // Recorrer los inputs de observaciones
    form.querySelectorAll('input[name^="observaciones"]').forEach(input => {
        const nameParts = input.name.match(/observaciones\[(\d+)\]\[(\d+)\]/);
        if (nameParts) {
            const matriculaCursoId = nameParts[1];
            const sesionId = nameParts[2];

            if (!observaciones[matriculaCursoId]) {
                observaciones[matriculaCursoId] = {};
            }

            observaciones[matriculaCursoId][sesionId] = input.value;
        }
    });

    // 🔥 Agregamos console.log para VER que se está enviando 🔥
    console.log("Asistencias preparadas:", asistencias);
    console.log("Observaciones preparadas:", observaciones);

    fetch("<?php echo e(route('docente.asistencia.store', $curso->id)); ?>", {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        },
        body: JSON.stringify({
            asistencias: asistencias,
            observaciones: observaciones
        })
    })
    .then(response => response.json())
    .then(data => {
        console.log("Respuesta del servidor:", data); // 🔥 también aquí
        if(data.success) {
            Swal.fire({
                icon: 'success',
                title: 'Éxito',
                text: data.message,
                timer: 2000,
                showConfirmButton: false
            }).then(() => {
                //location.reload();
            });
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: data.message,
            });
        }
    })
    .catch(error => {
        console.error('Error en fetch:', error);
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'No se pudo registrar la asistencia.'
        });
    });
});
</script>






<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\SISTEMAS\academico-master\resources\views/docentes/asistencias/index.blade.php ENDPATH**/ ?>